package pl.gda.pg.concurrency.forks;

import java.util.concurrent.ForkJoinPool;

public class ForksDemo {

    public static void showForkDemoTask() {
        double[] arrayToSum = new double[50000];
        for (int i = 0; i < arrayToSum.length; i++) {
            arrayToSum[i] = 1;
        }

        int processors = Runtime.getRuntime().availableProcessors();
        System.out.println(Integer.toString(processors) + " processor" + (processors != 1 ? "s are " : " is ") + "available");

        ForkJoinPool pool = new ForkJoinPool();
        RecursiveSummer summer = new RecursiveSummer(arrayToSum, 0, arrayToSum.length-1, pool);

        long startTime = System.currentTimeMillis();
        Double result = pool.invoke(summer);
        long endTime = System.currentTimeMillis();

        System.out.println(result);
        System.out.println("Computation tool " + (endTime - startTime) + " milliseconds.");
    }

    public static void showForkDemoAction() {
        double[] arrayToInc = new double[50000];
        for (int i = 0; i < arrayToInc.length; i++) {
            arrayToInc[i] = 1;
        }

        RecursiveAdder adder = new RecursiveAdder(arrayToInc, 0, arrayToInc.length-1);
        ForkJoinPool pool = new ForkJoinPool();

        long startTime = System.currentTimeMillis();
        pool.invoke(adder);
        long endTime = System.currentTimeMillis();

        System.out.println("Computation tool " + (endTime - startTime) + " milliseconds.");
    }
}
